// Add a parameterized constructor.  
  
class Vehicle {   
  int passengerCapacity; // number of passengerCapacity   
  int fuelCapacity;    // fuel capacity in gallons
  int mpg;        // fuel consumption in miles per gallon  
  
  // constructor with formal parameters. 
  Vehicle(int p, int f, int m) { 
    passengerCapacity = p; 
    fuelCapacity = f; 
    mpg = m; 
  } 
 
  // Return the range.  
  int range() {  
    return mpg * fuelCapacity;  
  }  
  
  // Compute fuel needed for a given distance. 
  double getFuelNeeded(int miles) {  
    return (double) miles / mpg;  
  }  
}   
   
class VehicleConstructorDemo {   
  public static void main(String args[]) {   
 
    // construct complete vehicles 
    Vehicle minivan = new Vehicle(7, 16, 21);   
    Vehicle sportscar = new Vehicle(2, 14, 12);   
    double gallons;  
    int dist = 252;  
  
    gallons = minivan.getFuelNeeded(dist);   
   
    System.out.println("To go " + dist + " miles minivan needs " +  
                       gallons + " gallons of fuel.");  
      
    gallons = sportscar.getFuelNeeded(dist);   
   
    System.out.println("To go " + dist + " miles sportscar needs " +  
                       gallons + " gallons of fuel.");  
      
  }   
}